#####################################################
#   Sieve of Erstothenes
#   written to compare speed of Fortran vs Python
#   	Ian Robinson
#			www.starfishprime.co.uk
#####################################################

import numpy as np
import time
N=1000000000



startTime = time.perf_counter()

midPoint = int(N/2)
rootN= int(np.sqrt(N))

# Initialise the array elements to true ..
Primes=np.ones((N+2),dtype="bool")


print("The Sieving Begins")

startPos=2
while 1:
	j=0
	sqrStartPos = (startPos*startPos)
	while 1:
		i = sqrStartPos + (j*startPos)
		if (i>N): break
		Primes[i] = False
		j=j+1
		
	while 1:
		startPos=startPos+1
		if (Primes[startPos]==True): break
	
	if (startPos > rootN): break


stopTime = time.perf_counter()
print("Elapsed time, s : ", (stopTime - startTime))

n_primes=0
for i in range(2,N):
	if(Primes[i]==True): n_primes=n_primes+1

print ("Number of primes 2-", N, "  = ", n_primes)

